VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "CWord"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit
'------------------------------------------------------------------
' Name : CWord
'
' Purpose : Purpose an interface to help access to Microsoft Word
'
' Method:
'   1) NewDocument      Open a new document in word (use a previous instance of word if loaded or load it)
'   2) DefinePageSetup  Change Left and Right Margin
'   3) SelectSeekView   Select a view for apply further commands (Footer, Header, Content)
'   4) FillCurrentRow   Fill a row of data in a word table from a grid (with visible column define by LC)
'
' review : Nov/19/1999 by JJB
'------------------------------------------------------------------

Public mo_appWD As Object 'Word.Application

Public Enum TFormatColumn
    Default = 0
    AlignCenter = 1
    AlignRight = 2
    AlignLeft = 0
End Enum

Public Enum WdSeekView
    wdSeekMainDocument = 0
    wdSeekPrimaryHeader = 1
    wdSeekFirstPageHeader = 2
    wdSeekEvenPagesHeader = 3
    wdSeekPrimaryFooter = 4
    wdSeekFirstPageFooter = 5
    wdSeekEvenPagesFooter = 6
    wdSeekFootnotes = 7
    wdSeekEndnotes = 8
    wdSeekCurrentPageHeader = 9
    wdSeekCurrentPageFooter = 10
End Enum

Public Enum WdTabAlignment
    wdAlignTabLeft = 0
    wdAlignTabCenter = 1
    wdAlignTabRight = 2
    wdAlignTabDecimal = 3
    wdAlignTabBar = 4
    wdAlignTabList = 6
End Enum

Public Enum WdTableFormat
    wdTableFormatNone = 0
    wdTableFormatSimple1 = 1
    wdTableFormatSimple2 = 2
    wdTableFormatSimple3 = 3
    wdTableFormatClassic1 = 4
    wdTableFormatClassic2 = 5
    wdTableFormatClassic3 = 6
    wdTableFormatClassic4 = 7
    wdTableFormatColorful1 = 8
    wdTableFormatColorful2 = 9
    wdTableFormatColorful3 = 10
    wdTableFormatColumns1 = 11
    wdTableFormatColumns2 = 12
    wdTableFormatColumns3 = 13
    wdTableFormatColumns4 = 14
    wdTableFormatColumns5 = 15
    wdTableFormatGrid1 = 16
    wdTableFormatGrid2 = 17
    wdTableFormatGrid3 = 18
    wdTableFormatGrid4 = 19
    wdTableFormatGrid5 = 20
    wdTableFormatGrid6 = 21
    wdTableFormatGrid7 = 22
    wdTableFormatGrid8 = 23
    wdTableFormatList1 = 24
    wdTableFormatList2 = 25
    wdTableFormatList3 = 26
    wdTableFormatList4 = 27
    wdTableFormatList5 = 28
    wdTableFormatList6 = 29
    wdTableFormatList7 = 30
    wdTableFormatList8 = 31
    wdTableFormat3DEffects1 = 32
    wdTableFormat3DEffects2 = 33
    wdTableFormat3DEffects3 = 34
    wdTableFormatContemporary = 35
    wdTableFormatElegant = 36
    wdTableFormatProfessional = 37
    wdTableFormatSubtle1 = 38
    wdTableFormatSubtle2 = 39
End Enum

Public Enum WdOrientation
    wdOrientPortrait = 0
    wdOrientLandscape = 1
End Enum

Public Enum WdPaperTray
    wdPrinterDefaultBin = 0
    wdPrinterUpperBin = 1
    wdPrinterOnlyBin = 1
    wdPrinterLowerBin = 2
    wdPrinterMiddleBin = 3
    wdPrinterManualFeed = 4
    wdPrinterEnvelopeFeed = 5
    wdPrinterManualEnvelopeFeed = 6
    wdPrinterAutomaticSheetFeed = 7
    wdPrinterTractorFeed = 8
    wdPrinterSmallFormatBin = 9
    wdPrinterLargeFormatBin = 10
    wdPrinterLargeCapacityBin = 11
    wdPrinterPaperCassette = 14
    wdPrinterFormSource = 15
End Enum

Public Enum WdSectionStart
    wdSectionContinuous = 0
    wdSectionNewColumn = 1
    wdSectionNewPage = 2
    wdSectionEvenPage = 3
    wdSectionOddPage = 4
End Enum

Public Enum WdVerticalAlignment
    wdAlignVerticalTop = 0
    wdAlignVerticalCenter = 1
    wdAlignVerticalJustify = 2
    wdAlignVerticalBottom = 3
End Enum

Public Enum WdSpecialPane
    wdPaneNone = 0
    wdPanePrimaryHeader = 1
    wdPaneFirstPageHeader = 2
    wdPaneEvenPagesHeader = 3
    wdPanePrimaryFooter = 4
    wdPaneFirstPageFooter = 5
    wdPaneEvenPagesFooter = 6
    wdPaneFootnotes = 7
    wdPaneEndnotes = 8
    wdPaneFootnoteContinuationNotice = 9
    wdPaneFootnoteContinuationSeparator = 10
    wdPaneFootnoteSeparator = 11
    wdPaneEndnoteContinuationNotice = 12
    wdPaneEndnoteContinuationSeparator = 13
    wdPaneEndnoteSeparator = 14
    wdPaneComments = 15
    wdPaneCurrentPageHeader = 16
    wdPaneCurrentPageFooter = 17
End Enum

Public Enum WdViewType
    wdNormalView = 1
    wdOutlineView = 2
    wdPageView = 3
    wdPrintPreview = 4
    wdMasterView = 5
    wdOnlineView = 6
End Enum

Public Enum WdUnits
    wdCharacter = 1
    wdWord = 2
    wdSentence = 3
    wdParagraph = 4
    wdLine = 5
    wdStory = 6
    wdScreen = 7
    wdSection = 8
    wdColumn = 9
    wdRow = 10
    wdWindow = 11
    wdCell = 12
    wdCharacterFormatting = 13
    wdParagraphFormatting = 14
    wdTable = 15
    wdItem = 16
End Enum

Public Enum WdRelativeHorizontalPosition
    wdRelativeHorizontalPositionMargin = 0
    wdRelativeHorizontalPositionPage = 1
    wdRelativeHorizontalPositionColumn = 2
End Enum

Public Enum WdRelativeVerticalPosition
    wdRelativeVerticalPositionMargin = 0
    wdRelativeVerticalPositionPage = 1
    wdRelativeVerticalPositionParagraph = 2
End Enum

Public Enum WdWrapType
    wdWrapSquare = 0
    wdWrapTight = 1
    wdWrapThrough = 2
    wdWrapNone = 3
    wdWrapTopBottom = 4
End Enum

Public Enum WdWrapSideType
    wdWrapBoth = 0
    wdWrapLeft = 1
    wdWrapRight = 2
    wdWrapLargest = 3
End Enum

Public Enum WdTabLeader
    wdTabLeaderSpaces = 0
    wdTabLeaderDots = 1
    wdTabLeaderDashes = 2
    wdTabLeaderLines = 3
End Enum

Public Enum WdRulerStyle
    wdAdjustNone = 0
    wdAdjustProportional = 1
    wdAdjustFirstColumn = 2
    wdAdjustSameWidth = 3
End Enum

Public Function NewDocument(ByVal ls_Template As String) As Boolean
'------------------------------------------------------------------
' Name :    NewDocument
'
' Purpose :
'
' Parameters : ls_template  : .dot file
'
' review : Nov/19/1999 by JJB
'------------------------------------------------------------------
    
    NewDocument = KO
    Err.Number = 0
    On Error GoTo Err_NotLoaded
    Set mo_appWD = GetObject(, "Word.Application")
    On Error GoTo Err_Print
    'lo_appWD.Documents.Open ("c:\print.doc")
    'If ls_template <> "" Then
    mo_appWD.Documents.Add ls_Template
    'Else
    '    mo_appWD.Documents.Add
    'End If
    NewDocument = OK
    Exit Function
    
Err_NotLoaded:
    If Err.Number = 429 Then
        Set mo_appWD = CreateObject("Word.Application")
        Resume Next
    Else
        GoTo Abort_Print
    End If
    
    MouseOn
    Exit Function
    
Err_Print:
Abort_Print:
    MsgBox Err.Description
    On Error Resume Next
    Set mo_appWD = Nothing
    MouseOn
End Function



Private Function DefinePageSetup(ByVal LeftMargin As Single, ByVal RightMargin As Single) As Boolean
'------------------------------------------------------------------
' Name :    DefinePageSetup
'
' Purpose :
'
' Parameters :
'
' review : Nov/19/1999 by JJB
'------------------------------------------------------------------
'On Error GoTo Err_DefinePageSetup

DefinePageSetup = KO
    'define right and left margin
    With mo_appWD.ActiveDocument.PageSetup
        .LineNumbering.Active = False
        .Orientation = wdOrientPortrait
        .topMargin = mo_appWD.CentimetersToPoints(2.54)
        .bottomMargin = mo_appWD.CentimetersToPoints(2.54)
        .LeftMargin = mo_appWD.CentimetersToPoints(LeftMargin)
        .RightMargin = mo_appWD.CentimetersToPoints(RightMargin)
        .Gutter = mo_appWD.CentimetersToPoints(0)
        .HeaderDistance = mo_appWD.CentimetersToPoints(1.25)
        .FooterDistance = mo_appWD.CentimetersToPoints(1.25)
        .PageWidth = mo_appWD.CentimetersToPoints(21.59)
        .PageHeight = mo_appWD.CentimetersToPoints(27.94)
        .FirstPageTray = wdPrinterDefaultBin
        .OtherPagesTray = wdPrinterDefaultBin
        .SectionStart = wdSectionNewPage
        .OddAndEvenPagesHeaderFooter = False
        .DifferentFirstPageHeaderFooter = False
        .VerticalAlignment = wdAlignVerticalTop
        .SuppressEndnotes = False
        .MirrorMargins = False
    End With
DefinePageSetup = OK

'Err_DefinePageSetup:

End Function

Private Function SelectSeekView(len_SeekView As WdSeekView) As Boolean
'------------------------------------------------------------------
' Name :    SelectSeekView
'
' Purpose :
'
' Parameters :
'
' review : Nov/19/1999 by JJB
'------------------------------------------------------------------
SelectSeekView = KO
'select the header
    If mo_appWD.ActiveWindow.View.SplitSpecial <> wdPaneNone Then
        mo_appWD.ActiveWindow.Panes(2).Close
        End If
    If mo_appWD.ActiveWindow.ActivePane.View.Type = wdNormalView _
      Or mo_appWD.ActiveWindow.ActivePane.View.Type = wdOutlineView _
      Or mo_appWD.ActiveWindow.ActivePane.View.Type = wdMasterView Then
        mo_appWD.ActiveWindow.ActivePane.View.Type = wdPageView
        End If
    mo_appWD.ActiveWindow.ActivePane.View.SeekView = len_SeekView 'wdSeekCurrentPageHeader
    
SelectSeekView = OK

End Function

Public Function FillCurrentRow(li_Row As Integer, lo_Grid As MSFlexGridLib.MSFlexGrid, lc, lo_FormatColumn)
'------------------------------------------------------------------
' Name :    FillCurrentRow
'
' Purpose :
'
' Parameters :
'
' review : Nov/19/1999 by JJB
'------------------------------------------------------------------
' condition : be on the first cell of the current row
Dim li_CurrGridCol As Integer
Dim lb_First As Boolean
Dim lb_Last As Boolean
Dim li_CurrTabCol As Integer

lb_First = OK
lb_Last = KO
lo_Grid.Row = li_Row
li_CurrTabCol = 0
For li_CurrGridCol = 0 To UBound(lc, 1)
    If lc(li_CurrGridCol) <> 0 Then
        If lb_First Then
            lb_First = KO
        Else
                mo_appWD.selection.MoveRight Unit:=wdCell
        End If
    'Description
        lo_Grid.Col = li_CurrGridCol
            '.Alignment = wdAlignParagraphRight
            mo_appWD.selection.ParagraphFormat.Alignment = lo_FormatColumn(li_CurrTabCol)
            
        li_CurrTabCol = li_CurrTabCol + 1
            mo_appWD.selection.TypeText Text:=lo_Grid.Text
    End If
Next

End Function


Public Function FillInCol(li_Row As Integer, lo_Grid As MSFlexGridLib.MSFlexGrid, lc, lo_FormatColumn)
'------------------------------------------------------------------
' Name :    FillInCol
'
' Purpose :
'
' Parameters :
'
' review : Jul/4/1999 by JJB
'------------------------------------------------------------------
' condition : be on the first cell of the current row
Dim li_CurrGridCol As Integer
Dim lb_First As Boolean
Dim lb_Last As Boolean
Dim li_CurrTabCol As Integer

lb_First = OK
For li_CurrGridCol = 0 To lo_Grid.Cols - 1
        If lb_First Then
            lb_First = KO
        Else
                mo_appWD.selection.MoveRight Unit:=wdCell
        End If
        'Description
        lo_Grid.Row = 0
        lo_Grid.Col = li_CurrGridCol
            mo_appWD.selection.TypeText Text:=lo_Grid.Text
            mo_appWD.selection.MoveRight Unit:=wdCell
        lo_Grid.Row = li_Row
        lo_Grid.Col = li_CurrGridCol
            mo_appWD.selection.TypeText Text:=lo_Grid.Text
    
Next

End Function

Public Function InsertBitMap(ByVal Lsng_XPos As Single, ByVal Lsng_YPos As Single, ByVal ls_FileName As String) As Boolean
'------------------------------------------------------------------
' Name :    InsertBitMap
'
' Purpose : Load a bitmap from a file and insert it in the document (the bitmap float over text)
'
' Parameters :  ls_FileName : Name of the bitmap file to use
'
' review : Nov/19/1999 by JJB
'------------------------------------------------------------------
    InsertBitMap = KO
    
    mo_appWD.ActiveDocument.Shapes.AddOLEObject Anchor:=mo_appWD.selection.Range, ClassType:= _
            "Paint.Picture", FileName:=ls_FileName, LinkToFile:=KO, _
            DisplayAsIcon:=KO
    mo_appWD.selection.ShapeRange.RelativeHorizontalPosition = wdRelativeHorizontalPositionPage
    mo_appWD.selection.ShapeRange.RelativeVerticalPosition = wdRelativeVerticalPositionPage
    mo_appWD.selection.ShapeRange.left = mo_appWD.CentimetersToPoints(Lsng_XPos)
    mo_appWD.selection.ShapeRange.top = mo_appWD.CentimetersToPoints(Lsng_YPos)
    mo_appWD.selection.ShapeRange.LockAnchor = OK
    mo_appWD.selection.ShapeRange.WrapFormat.Type = wdWrapTopBottom
    mo_appWD.selection.ShapeRange.WrapFormat.Side = wdWrapBoth
    mo_appWD.selection.ShapeRange.WrapFormat.DistanceTop = mo_appWD.CentimetersToPoints(0)
    mo_appWD.selection.ShapeRange.WrapFormat.DistanceBottom = mo_appWD.CentimetersToPoints(0)
    mo_appWD.selection.ShapeRange.WrapFormat.DistanceLeft = mo_appWD.CentimetersToPoints(0.32)
    mo_appWD.selection.ShapeRange.WrapFormat.DistanceRight = mo_appWD.CentimetersToPoints(0.32)

    InsertBitMap = OK
End Function


Public Function RemoveTabStops(ByVal ls_Position As Single)
'------------------------------------------------------------------
' Name :    RemoveTabStops
'
' Purpose :
'
' Parameters :  ls_Position : Position of an existing TabStops
'
' review : Nov/19/1999 by JJB
'------------------------------------------------------------------
    RemoveTabStops = KO
    mo_appWD.selection.ParagraphFormat.TabStops(mo_appWD.CentimetersToPoints(ls_Position)).Clear
    RemoveTabStops = OK
End Function

Public Function AddTabStops(ByVal lo_TypeTab As WdTabAlignment, ByVal ls_Position As Single)
'------------------------------------------------------------------
' Name :    AddTabStops
'
' Purpose :
'
' Parameters :  ls_Position : Position of the futur TabStops
'
' review : Nov/19/1999 by JJB
'------------------------------------------------------------------
    AddTabStops = KO
    
    mo_appWD.selection.ParagraphFormat.TabStops.Add Position:=mo_appWD.CentimetersToPoints(ls_Position), Alignment:=lo_TypeTab, Leader:=wdTabLeaderSpaces
    
    AddTabStops = OK
End Function


Public Function CreateTable(lc, lo_TAbleTemplate As WdTableFormat) As Object
'------------------------------------------------------------------
' Name :    AddTabStops
'
' Purpose : Return Table Object
'
' Parameters :  ls_Position : Position of the futur TabStops
'
' review : Nov/19/1999 by JJB
'------------------------------------------------------------------
Dim li_CurrGridCol As Integer
Dim li_CurrWordTableCol As Integer
Dim li_GridTotalSize As Integer
Dim li_ColumnNumber As Integer
Dim lb_First As Boolean
Dim lb_Last As Boolean
Dim lsng_WordContentSize As Single
Dim lo_myTable As Object 'Table

    'CreateTable = KO
    li_GridTotalSize = 0
    li_ColumnNumber = 0
    For li_CurrGridCol = 0 To UBound(lc, 1)
        li_GridTotalSize = li_GridTotalSize + lc(li_CurrGridCol)
        If lc(li_CurrGridCol) <> 0 Then
            li_ColumnNumber = li_ColumnNumber + 1
        End If
    Next
    
    ' With ActiveDocument.PageSetup
    '    lsng_WordContentSize = .PageWidth - .LeftMargin - .RightMargin
    'End With
    
    mo_appWD.selection.TypeParagraph
    Set lo_myTable = mo_appWD.ActiveDocument.Tables.Add(Range:=mo_appWD.selection.Range, NumRows:=2, NumColumns:=li_ColumnNumber)
    lo_myTable.AutoFormat Format:=lo_TAbleTemplate, ApplyBorders:= _
        True, ApplyShading:=True, ApplyFont:=True, ApplyColor:=True, _
        ApplyHeadingRows:=True, ApplyLastRow:=False, ApplyFirstColumn:=False, _
        ApplyLastColumn:=False, AutoFit:=False
    lsng_WordContentSize = lo_myTable.Columns.Width * li_ColumnNumber
    li_CurrWordTableCol = 0
    For li_CurrGridCol = 0 To UBound(lc, 1)
        If lc(li_CurrGridCol) <> 0 Then
            li_CurrWordTableCol = li_CurrWordTableCol + 1
           ' Selection.Tables(1).Columns(li_CurrWordTableCol).Cells.
            lo_myTable.Columns(li_CurrWordTableCol).SetWidth ColumnWidth:=lsng_WordContentSize / li_GridTotalSize * lc(li_CurrGridCol), RulerStyle:=wdAdjustNone
        End If
    Next
    
    Set CreateTable = lo_myTable
    'CreateTable = OK
End Function


Public Function ExportQuotationToWord(ByVal ls_PrintingTitle As String, ByVal ls_Template As String, ls_QuotCode As String, ls_Version As String, ls_Language_Code As String, lo_Grid As MSFlexGridLib.MSFlexGrid, lc, lo_GridComment As MSFlexGridLib.MSFlexGrid, lo_FormatColumnHeader, lo_FormatColumn, ls_TxtHeader As String, ls_TxtFooter As String) As Boolean
'------------------------------------------------------------------
' Name :    ExportQuotationToWord
'
' Purpose :
'
' Parameters :
'
' review : Nov/19/1999 by JJB
'------------------------------------------------------------------
Dim i As Integer
Dim li_HRecord As Integer
'Dim li_LPaper As Integer
Dim li_XStartTable As Integer
Dim li_YStartTable As Integer

Dim ls_Req As String
Dim li_Status As Integer
Dim ll_Statement As Long
Dim ls_Field As String
Dim ls_Text As String

Dim ls_lblQuotID As String
Dim ls_lblResp  As String
Dim ls_lblDate  As String
Dim ls_lblFax  As String
Dim ls_lblCustomerID  As String
Dim ls_lblProjectId As String
Dim ls_lblProjectTown  As String
Dim ls_lblCustomerName  As String
Dim ls_lblCustomerTown As String
Dim ls_lblCustomerContact  As String
Dim ls_lblCustomerAddr1  As String
Dim ls_lblCustomerAddr2  As String
Dim ls_lblTotalAmount As String
Dim ls_lblTotalQty As String
Dim ls_lblPageNum As String
Dim ls_lblValidityDate  As String
Dim ls_lblComments  As String
Dim ls_lblLeadtime  As String
Dim ls_lblweeks As String
Dim ls_lblContractor As String

Dim ls_txtQuotID As String
Dim ls_txtResp  As String
Dim ls_txtDate  As String
Dim ls_txtFax  As String
Dim ls_txtCustomerID  As String
Dim ls_txtProjectId As String
Dim ls_txtProjectTown  As String
Dim ls_txtCustomerName  As String
Dim ls_txtCustomerTown As String
Dim ls_txtCustomerContact  As String
Dim ls_txtContractor As String
'Dim ls_lblComments As String
'Dim ls_lblLeadtime  As String
'Dim ls_txtCustomerAddr1  As String
'Dim ls_txtCustomerAddr2  As String
Dim ls_txtCurrency As String
Dim ls_txtValidityDate  As String
Dim ls_txtLeadtime As String


Dim li_Cell As Integer
Dim li_TempHRecord As Integer
Dim li_Count As Integer

Dim li_HeightBottomPage As Integer
Dim li_HeightBottomLastPage As Integer

Dim li_CurrGridRow As Integer



Dim lo_TableQuotLine As Object 'Table



'Read Translated constants


ls_Req = "EXEC Screen_Csts 'Quot_Print1', '" _
        & ls_Language_Code & "'"
If SQLSubmit(gl_Environment, gl_Database, ll_Statement, ls_Req) Then
    li_Status = SQL_SUCCESS
Else
    li_Status = SQL_ERROR
End If
Do While li_Status = SQL_SUCCESS Or li_Status = SQL_SUCCESS_WITH_INFO
    li_Status = SQLFetch(ll_Statement)
    If li_Status = SQL_SUCCESS Or li_Status = SQL_SUCCESS_WITH_INFO Then
        ls_Field = ODBCData(ll_Statement, 1)
        ls_Text = ODBCData(ll_Statement, 2)
        Select Case ls_Field
        '-- Top of the page
        Case "lbl_QuotID": ls_lblQuotID = ls_Text
        Case "lbl_Resp": ls_lblResp = ls_Text
        Case "lbl_Date": ls_lblDate = ls_Text
        Case "lbl_Fax": ls_lblFax = ls_Text
        Case "lbl_CustomerID": ls_lblCustomerID = ls_Text
        Case "lbl_ProjectId": ls_lblProjectId = ls_Text
        Case "lbl_ProjectTown": ls_lblProjectTown = ls_Text
        Case "lbl_CustomerName": ls_lblCustomerName = ls_Text
        Case "lbl_CustomerTown": ls_lblCustomerTown = ls_Text
        Case "lbl_CustomerContact": ls_lblCustomerContact = ls_Text
        Case "lbl_CustomerAddr1": ls_lblCustomerAddr1 = ls_Text
        Case "lbl_CustomerAddr2": ls_lblCustomerAddr2 = ls_Text
        Case "lbl_Contractor": ls_lblContractor = ls_Text
        '-- Array
        '-- End of the page
        Case "lbl_TotalAmount": ls_lblTotalAmount = ls_Text
        Case "lbl_TotalQty": ls_lblTotalQty = ls_Text
        Case "lbl_PageNum": ls_lblPageNum = ls_Text
        Case "lbl_ValidityDate": ls_lblValidityDate = ls_Text
        Case "lbl_Comments": ls_lblComments = ls_Text
        Case "lbl_Leadtime": ls_lblLeadtime = ls_Text
        Case "lbl_Weeks": ls_lblweeks = ls_Text
        End Select
    End If
Loop
li_Status = SQLFreeStatement(ll_Statement, SQL_DROP)

'read fusion field

ls_Req = "EXEC Quotation_PrintFusion_t_sel " & ls_QuotCode & "," & ls_Version & ",'" & ls_Language_Code & "'"
If SQLSubmit(gl_Environment, gl_Database, ll_Statement, ls_Req) Then
    li_Status = SQL_SUCCESS
Else
    li_Status = SQL_ERROR
End If
Do While li_Status = SQL_SUCCESS Or li_Status = SQL_SUCCESS_WITH_INFO
    li_Status = SQLFetch(ll_Statement)
    If li_Status = SQL_SUCCESS Or li_Status = SQL_SUCCESS_WITH_INFO Then
        '-- Top of the page
        ls_txtQuotID = ODBCData(ll_Statement, 1)
        ls_txtResp = ODBCData(ll_Statement, 2)
        ls_txtDate = ODBCData(ll_Statement, 3)
        ls_txtFax = ODBCData(ll_Statement, 4)
        ls_txtCustomerID = ODBCData(ll_Statement, 5)
        ls_txtProjectId = ODBCData(ll_Statement, 6)
        ls_txtProjectTown = ODBCData(ll_Statement, 7)
        ls_txtCustomerName = ODBCData(ll_Statement, 8)
        ls_txtCustomerContact = ODBCData(ll_Statement, 9)
'        ls_txtCustomerAddr1 = ODBCData(ll_Statement, 10)
'        ls_txtCustomerAddr2 = ODBCData(ll_Statement, 11)
        ls_txtCustomerTown = ODBCData(ll_Statement, 10)
        '-- Array
        
        ls_txtCurrency = ODBCData(ll_Statement, 11)
        '-- End of the page
        'ls_Leadtime = ODBCData(ll_Statement, 12)
        
        ls_txtValidityDate = ODBCData(ll_Statement, 12)
        ls_txtLeadtime = ODBCData(ll_Statement, 13)
        ls_txtContractor = ODBCData(ll_Statement, 14)
    End If
Loop
li_Status = SQLFreeStatement(ll_Statement, SQL_DROP)

''adding /currency in the title of the table
'lo_Grid.Row = 0
'lo_Grid.col = 8
'lo_Grid.Text = lo_Grid.Text & "/" & ls_txtCurrency



ExportQuotationToWord = KO

 If NewDocument(ls_Template) Then
    mo_appWD.Visible = OK
    'define right and left margin
    'Call DefinePageSetup(1.5, 1.5)
    'select the header
    Call SelectSeekView(wdSeekCurrentPageHeader)
    'construct the header
    'Define tabs of the header
    'RemoveTabStops (7.62)
    AddTabStops wdAlignTabLeft, 3.75
    AddTabStops wdAlignTabLeft, 8.5
    AddTabStops wdAlignTabLeft, 13
    'insert fields in the header
    mo_appWD.selection.Font.Size = 20
    mo_appWD.selection.Font.Bold = OK
    mo_appWD.selection.TypeText Text:=ls_PrintingTitle
    mo_appWD.selection.TypeParagraph
    mo_appWD.selection.Font.Size = 14
    mo_appWD.selection.Font.Bold = OK
    mo_appWD.selection.TypeText Text:=vbTab & vbTab & ls_lblQuotID
    mo_appWD.selection.Font.Bold = KO
    mo_appWD.selection.TypeText Text:=vbTab & ls_txtQuotID
    mo_appWD.selection.Font.Size = 10
    mo_appWD.selection.TypeParagraph
    mo_appWD.selection.Font.Bold = OK
    mo_appWD.selection.TypeText Text:=vbTab & vbTab & ls_lblResp
    mo_appWD.selection.Font.Bold = KO
    mo_appWD.selection.TypeText Text:=vbTab & ls_txtResp
    mo_appWD.selection.TypeParagraph
    mo_appWD.selection.Font.Bold = OK
    mo_appWD.selection.TypeText Text:=ls_lblContractor
    mo_appWD.selection.Font.Bold = KO
    mo_appWD.selection.TypeText Text:=vbTab & ls_txtContractor
    mo_appWD.selection.Font.Bold = OK
    mo_appWD.selection.TypeText Text:=vbTab & ls_lblDate
    mo_appWD.selection.Font.Bold = KO
    mo_appWD.selection.TypeText Text:=vbTab & ls_txtDate
    mo_appWD.selection.TypeParagraph
    mo_appWD.selection.TypeParagraph
    mo_appWD.selection.Font.Bold = OK
    mo_appWD.selection.TypeText Text:=ls_lblCustomerName
    mo_appWD.selection.Font.Bold = KO
    mo_appWD.selection.TypeText Text:=vbTab & ls_txtCustomerName
    mo_appWD.selection.Font.Bold = OK
    mo_appWD.selection.TypeText Text:=vbTab & ls_lblFax
    mo_appWD.selection.Font.Bold = KO
    mo_appWD.selection.TypeText Text:=vbTab & ls_txtFax
    mo_appWD.selection.TypeParagraph
        
    mo_appWD.selection.Font.Bold = OK
    mo_appWD.selection.TypeText Text:=ls_lblCustomerTown
    mo_appWD.selection.Font.Bold = KO
    mo_appWD.selection.TypeText Text:=vbTab & ls_txtCustomerTown
    mo_appWD.selection.Font.Bold = OK
    mo_appWD.selection.TypeText Text:=vbTab & ls_lblCustomerID
    mo_appWD.selection.Font.Bold = KO
    mo_appWD.selection.TypeText Text:=vbTab & ls_txtCustomerID
    mo_appWD.selection.TypeParagraph
    mo_appWD.selection.Font.Bold = OK
    mo_appWD.selection.TypeText Text:=ls_lblCustomerContact & vbTab
    mo_appWD.selection.Font.Bold = KO
    mo_appWD.selection.TypeText Text:=ls_txtCustomerContact & vbTab
    mo_appWD.selection.Font.Bold = OK
    mo_appWD.selection.TypeText Text:=ls_lblProjectId & vbTab
    mo_appWD.selection.Font.Bold = KO
    mo_appWD.selection.TypeText Text:=ls_txtProjectId
    mo_appWD.selection.TypeParagraph
        RemoveTabStops (3.75)
    mo_appWD.selection.TypeText Text:=vbTab
    mo_appWD.selection.Font.Bold = OK
    mo_appWD.selection.TypeText Text:=ls_lblProjectTown & vbTab
    mo_appWD.selection.Font.Bold = KO
    mo_appWD.selection.TypeText Text:=ls_txtProjectTown
    mo_appWD.selection.TypeParagraph
    mo_appWD.selection.TypeParagraph
    mo_appWD.selection.TypeText Text:=ls_TxtHeader
    
    'Call InsertBitMap(1.5, 1.25, App.Path & "\armstrong.bmp")
    
    'select the document
    Call SelectSeekView(wdSeekMainDocument)
        
        Set lo_TableQuotLine = CreateTable(lc, wdTableFormatProfessional)
        'define row number one as title repeated on each page
        lo_TableQuotLine.Rows(1).HeadingFormat = OK
        For li_CurrGridRow = 0 To lo_Grid.Rows - 1
            ' fill the row
            If li_CurrGridRow = 0 Then
                Call FillCurrentRow(li_CurrGridRow, lo_Grid, lc, lo_FormatColumnHeader)
            Else
                Call FillCurrentRow(li_CurrGridRow, lo_Grid, lc, lo_FormatColumn)
            End If
            ' insert next row
            If (li_CurrGridRow < (lo_Grid.Rows - 1)) Then
             mo_appWD.selection.MoveRight Unit:=wdCell
            End If
        Next
        
        'exit the table on the last line
        If lo_Grid.Rows = 1 Then
         mo_appWD.selection.MoveDown Unit:=wdLine, Count:=1
        End If
     mo_appWD.selection.MoveDown Unit:=wdParagraph, Count:=2
       
     mo_appWD.selection.TypeParagraph
     mo_appWD.selection.Font.Bold = OK
     mo_appWD.selection.TypeText Text:=ls_lblComments
     mo_appWD.selection.Font.Bold = KO
     mo_appWD.selection.TypeParagraph
'        'Insert the Comments
        For li_CurrGridRow = 0 To lo_GridComment.Rows - 1
            lo_GridComment.Row = li_CurrGridRow
         mo_appWD.selection.TypeText Text:=lo_GridComment.Text
         mo_appWD.selection.TypeParagraph
        Next


'        If lo_GridTotal.Rows = 1 Then
'        Selection.TypeParagraph
'            End If
'        RemoveTabStops 9.5
'        RemoveTabStops 10.75
'        RemoveTabStops 13.75
'        RemoveTabStops 16.25
'        RemoveTabStops 18.5
        'insert the Footer after the table
     mo_appWD.selection.TypeParagraph
     mo_appWD.selection.Font.Bold = OK
     mo_appWD.selection.TypeText Text:=ls_lblLeadtime
     mo_appWD.selection.Font.Bold = KO
     mo_appWD.selection.TypeText Text:=" " & ls_txtLeadtime & " " & ls_lblweeks
     mo_appWD.selection.TypeParagraph
     mo_appWD.selection.Font.Bold = OK
     mo_appWD.selection.TypeText Text:=ls_lblValidityDate
     mo_appWD.selection.Font.Bold = KO
     mo_appWD.selection.TypeText Text:=" " & ls_txtValidityDate
     mo_appWD.selection.TypeParagraph
     mo_appWD.selection.TypeText Text:=ls_TxtFooter

    'select the document
    'Call SelectSeekView(wdSeekCurrentPageFooter)
    'insert PAGE X OF Y
    'With mo_appWD
     '   NormalTemplate.AutoTextEntries("Page X of Y").Insert Where:=Selection. _
     '       Range
    'End With
    'Call SelectSeekView(wdSeekMainDocument)
    
 End If
 
Set lo_TableQuotLine = Nothing
ExportQuotationToWord = OK

End Function




Public Function ExportQuotationMetalToWord(ByVal ls_PrintingTitle As String, ByVal ls_Template As String, ls_QuotCode As String, ls_Version As String, ls_Language_Code As String, lo_Grid As MSFlexGridLib.MSFlexGrid, lo_GridComment As MSFlexGridLib.MSFlexGrid, ls_TxtHeader As String, ls_TxtFooter As String) As Boolean
'------------------------------------------------------------------
' Name :    ExportQuotationToWord
'
' Purpose :
'
' Parameters :
'
' review : Nov/19/1999 by JJB
'------------------------------------------------------------------
Dim i As Integer
Dim li_HRecord As Integer
'Dim li_LPaper As Integer
Dim li_XStartTable As Integer
Dim li_YStartTable As Integer

Dim ls_Req As String
Dim li_Status As Integer
Dim ll_Statement As Long
Dim ls_Field As String
Dim ls_Text As String

Dim ls_lblQuotID As String
Dim ls_lblResp  As String
Dim ls_lblDate  As String
Dim ls_lblFax  As String
Dim ls_lblCustomerID  As String
Dim ls_lblProjectId As String
Dim ls_lblProjectTown  As String
Dim ls_lblCustomerName  As String
Dim ls_lblCustomerTown As String
Dim ls_lblCustomerContact  As String
Dim ls_lblCustomerAddr1  As String
Dim ls_lblCustomerAddr2  As String
Dim ls_lblTotalAmount As String
Dim ls_lblTotalQty As String
Dim ls_lblPageNum As String
Dim ls_lblValidityDate  As String
Dim ls_lblComments  As String
Dim ls_lblLeadtime  As String
Dim ls_lblweeks As String
Dim ls_lblContractor As String


Dim ls_txtQuotID As String
Dim ls_txtResp  As String
Dim ls_txtDate  As String
Dim ls_txtFax  As String
Dim ls_txtCustomerID  As String
Dim ls_txtProjectId As String
Dim ls_txtProjectTown  As String
Dim ls_txtCustomerName  As String
Dim ls_txtCustomerTown As String
Dim ls_txtCustomerContact  As String
Dim ls_txtContractor As String
'Dim ls_lblComments As String
'Dim ls_lblLeadtime  As String
'Dim ls_txtCustomerAddr1  As String
'Dim ls_txtCustomerAddr2  As String
Dim ls_txtCurrency As String
Dim ls_txtValidityDate  As String
Dim ls_txtLeadtime As String


Dim li_Cell As Integer
Dim li_TempHRecord As Integer
Dim li_Count As Integer

Dim li_HeightBottomPage As Integer
Dim li_HeightBottomLastPage As Integer

Dim li_CurrGridRow As Integer



Dim lo_TableQuotLine As Object 'Table

'Read Translated constants

ls_Req = "EXEC Screen_Csts 'Quot_Print1', '" _
        & ls_Language_Code & "'"
If SQLSubmit(gl_Environment, gl_Database, ll_Statement, ls_Req) Then
    li_Status = SQL_SUCCESS
Else
    li_Status = SQL_ERROR
End If
Do While li_Status = SQL_SUCCESS Or li_Status = SQL_SUCCESS_WITH_INFO
    li_Status = SQLFetch(ll_Statement)
    If li_Status = SQL_SUCCESS Or li_Status = SQL_SUCCESS_WITH_INFO Then
        ls_Field = ODBCData(ll_Statement, 1)
        ls_Text = ODBCData(ll_Statement, 2)
        Select Case ls_Field
        '-- Top of the page
        Case "lbl_QuotID": ls_lblQuotID = ls_Text
        Case "lbl_Resp": ls_lblResp = ls_Text
        Case "lbl_Date": ls_lblDate = ls_Text
        Case "lbl_Fax": ls_lblFax = ls_Text
        Case "lbl_CustomerID": ls_lblCustomerID = ls_Text
        Case "lbl_ProjectId": ls_lblProjectId = ls_Text
        Case "lbl_ProjectTown": ls_lblProjectTown = ls_Text
        Case "lbl_CustomerName": ls_lblCustomerName = ls_Text
        Case "lbl_CustomerTown": ls_lblCustomerTown = ls_Text
        Case "lbl_CustomerContact": ls_lblCustomerContact = ls_Text
        Case "lbl_CustomerAddr1": ls_lblCustomerAddr1 = ls_Text
        Case "lbl_CustomerAddr2": ls_lblCustomerAddr2 = ls_Text
        '-- Array
        '-- End of the page
        Case "lbl_TotalAmount": ls_lblTotalAmount = ls_Text
        Case "lbl_TotalQty": ls_lblTotalQty = ls_Text
        Case "lbl_PageNum": ls_lblPageNum = ls_Text
        Case "lbl_ValidityDate": ls_lblValidityDate = ls_Text
        Case "lbl_Comments": ls_lblComments = ls_Text
        Case "lbl_Leadtime": ls_lblLeadtime = ls_Text
        Case "lbl_Weeks": ls_lblweeks = ls_Text
        Case "lbl_Contractor": ls_lblContractor = ls_Text
        End Select
    End If
Loop
li_Status = SQLFreeStatement(ll_Statement, SQL_DROP)

'read fusion field

ls_Req = "EXEC Quotation_PrintFusion_t_sel " & ls_QuotCode & "," & ls_Version & ",'" & ls_Language_Code & "'"
If SQLSubmit(gl_Environment, gl_Database, ll_Statement, ls_Req) Then
    li_Status = SQL_SUCCESS
Else
    li_Status = SQL_ERROR
End If
Do While li_Status = SQL_SUCCESS Or li_Status = SQL_SUCCESS_WITH_INFO
    li_Status = SQLFetch(ll_Statement)
    If li_Status = SQL_SUCCESS Or li_Status = SQL_SUCCESS_WITH_INFO Then
        '-- Top of the page
        ls_txtQuotID = ODBCData(ll_Statement, 1)
        ls_txtResp = ODBCData(ll_Statement, 2)
        ls_txtDate = ODBCData(ll_Statement, 3)
        ls_txtFax = ODBCData(ll_Statement, 4)
        ls_txtCustomerID = ODBCData(ll_Statement, 5)
        ls_txtProjectId = ODBCData(ll_Statement, 6)
        ls_txtProjectTown = ODBCData(ll_Statement, 7)
        ls_txtCustomerName = ODBCData(ll_Statement, 8)
        ls_txtCustomerContact = ODBCData(ll_Statement, 9)
'        ls_txtCustomerAddr1 = ODBCData(ll_Statement, 10)
'        ls_txtCustomerAddr2 = ODBCData(ll_Statement, 11)
        ls_txtCustomerTown = ODBCData(ll_Statement, 10)
        '-- Array
        
        ls_txtCurrency = ODBCData(ll_Statement, 11)
        '-- End of the page
        'ls_Leadtime = ODBCData(ll_Statement, 12)
        
        ls_txtValidityDate = ODBCData(ll_Statement, 12)
        ls_txtLeadtime = ODBCData(ll_Statement, 13)
        ls_txtContractor = ODBCData(ll_Statement, 14)
    End If
Loop
li_Status = SQLFreeStatement(ll_Statement, SQL_DROP)

''adding /currency in the title of the table
'lo_Grid.Row = 0
'lo_Grid.col = 8
'lo_Grid.Text = lo_Grid.Text & "/" & ls_txtCurrency



ExportQuotationMetalToWord = KO

 If NewDocument(ls_Template) Then
    mo_appWD.Visible = OK
    'define right and left margin
    'Call DefinePageSetup(1.5, 1.5)
    'select the header
    Call SelectSeekView(wdSeekCurrentPageHeader)
    'construct the header
    'Define tabs of the header
    'RemoveTabStops (7.62)
    AddTabStops wdAlignTabLeft, 3.75
    AddTabStops wdAlignTabLeft, 8.5
    AddTabStops wdAlignTabLeft, 13
    'insert fields in the header
    mo_appWD.selection.Font.Size = 20
    mo_appWD.selection.Font.Bold = OK
    mo_appWD.selection.TypeText Text:=ls_PrintingTitle
    mo_appWD.selection.TypeParagraph
    mo_appWD.selection.Font.Size = 14
    mo_appWD.selection.Font.Bold = OK
    mo_appWD.selection.TypeText Text:=vbTab & vbTab & ls_lblQuotID
    mo_appWD.selection.Font.Bold = KO
    mo_appWD.selection.TypeText Text:=vbTab & ls_txtQuotID
    mo_appWD.selection.Font.Size = 10
    mo_appWD.selection.TypeParagraph
    mo_appWD.selection.Font.Bold = OK
    mo_appWD.selection.TypeText Text:=vbTab & vbTab & ls_lblResp
    mo_appWD.selection.Font.Bold = KO
    mo_appWD.selection.TypeText Text:=vbTab & ls_txtResp
    mo_appWD.selection.TypeParagraph
    mo_appWD.selection.Font.Bold = OK
    mo_appWD.selection.TypeText Text:=ls_lblContractor
    mo_appWD.selection.Font.Bold = KO
    mo_appWD.selection.TypeText Text:=vbTab & ls_txtContractor
    mo_appWD.selection.Font.Bold = OK
    mo_appWD.selection.TypeText Text:=vbTab & ls_lblDate
    mo_appWD.selection.Font.Bold = KO
    mo_appWD.selection.TypeText Text:=vbTab & ls_txtDate
    mo_appWD.selection.TypeParagraph
    mo_appWD.selection.TypeParagraph
    mo_appWD.selection.Font.Bold = OK
    mo_appWD.selection.TypeText Text:=ls_lblCustomerName
    mo_appWD.selection.Font.Bold = KO
    mo_appWD.selection.TypeText Text:=vbTab & ls_txtCustomerName
    mo_appWD.selection.Font.Bold = OK
    mo_appWD.selection.TypeText Text:=vbTab & ls_lblFax
    mo_appWD.selection.Font.Bold = KO
    mo_appWD.selection.TypeText Text:=vbTab & ls_txtFax
    mo_appWD.selection.TypeParagraph
        
    mo_appWD.selection.Font.Bold = OK
    mo_appWD.selection.TypeText Text:=ls_lblCustomerTown
    mo_appWD.selection.Font.Bold = KO
    mo_appWD.selection.TypeText Text:=vbTab & ls_txtCustomerTown
    mo_appWD.selection.Font.Bold = OK
    mo_appWD.selection.TypeText Text:=vbTab & ls_lblCustomerID
    mo_appWD.selection.Font.Bold = KO
    mo_appWD.selection.TypeText Text:=vbTab & ls_txtCustomerID
    mo_appWD.selection.TypeParagraph
    mo_appWD.selection.Font.Bold = OK
    mo_appWD.selection.TypeText Text:=ls_lblCustomerContact & vbTab
    mo_appWD.selection.Font.Bold = KO
    mo_appWD.selection.TypeText Text:=ls_txtCustomerContact & vbTab
    mo_appWD.selection.Font.Bold = OK
    mo_appWD.selection.TypeText Text:=ls_lblProjectId & vbTab
    mo_appWD.selection.Font.Bold = KO
    mo_appWD.selection.TypeText Text:=ls_txtProjectId
    mo_appWD.selection.TypeParagraph
        RemoveTabStops (3.75)
    mo_appWD.selection.TypeText Text:=vbTab
    mo_appWD.selection.Font.Bold = OK
    mo_appWD.selection.TypeText Text:=ls_lblProjectTown & vbTab
    mo_appWD.selection.Font.Bold = KO
    mo_appWD.selection.TypeText Text:=ls_txtProjectTown
    mo_appWD.selection.TypeParagraph
    mo_appWD.selection.TypeParagraph
    mo_appWD.selection.TypeText Text:=ls_TxtHeader

    'Call InsertBitMap(1.5, 1.25, App.Path & "\armstrong.bmp")
    
    'select the document
    Call SelectSeekView(wdSeekMainDocument)
        
        'define row number one as title repeated on each page
'        lo_TableQuotLine.Rows(1).HeadingFormat = OK
        For li_CurrGridRow = 1 To lo_Grid.Rows - 1
                Set lo_TableQuotLine = CreateTable(Array(50, 50), wdTableFormatGrid1)
                Call FillInCol(li_CurrGridRow, lo_Grid, Array(50, 50), Array(TFormatColumn.AlignLeft, TFormatColumn.AlignCenter))
            mo_appWD.selection.MoveDown Unit:=wdLine, Count:=1
            mo_appWD.selection.TypeParagraph
        Next
        
        
        
        'exit the table on the last line
        If lo_Grid.Rows = 1 Then
        mo_appWD.selection.MoveDown Unit:=wdLine, Count:=1
        End If
     mo_appWD.selection.MoveDown Unit:=wdParagraph, Count:=2
        
    mo_appWD.selection.TypeParagraph
    mo_appWD.selection.Font.Bold = OK
    mo_appWD.selection.TypeText Text:=ls_lblComments
    mo_appWD.selection.Font.Bold = KO
    mo_appWD.selection.TypeParagraph
'        'Insert the Comments
        For li_CurrGridRow = 0 To lo_GridComment.Rows - 1
            lo_GridComment.Row = li_CurrGridRow
        mo_appWD.selection.TypeText Text:=lo_GridComment.Text
        mo_appWD.selection.TypeParagraph
        Next


'        If lo_GridTotal.Rows = 1 Then
'            Selection.TypeParagraph
'        End If
'        RemoveTabStops 9.5
'        RemoveTabStops 10.75
'        RemoveTabStops 13.75
'        RemoveTabStops 16.25
'        RemoveTabStops 18.5
        'insert the Footer after the table
    mo_appWD.selection.TypeParagraph
    mo_appWD.selection.Font.Bold = OK
    mo_appWD.selection.TypeText Text:=ls_lblLeadtime
    mo_appWD.selection.Font.Bold = KO
    mo_appWD.selection.TypeText Text:=" " & ls_txtLeadtime & ls_lblweeks
    mo_appWD.selection.TypeParagraph
    mo_appWD.selection.Font.Bold = OK
    mo_appWD.selection.TypeText Text:=ls_lblValidityDate
    mo_appWD.selection.Font.Bold = KO
    mo_appWD.selection.TypeText Text:=" " & ls_txtValidityDate
    mo_appWD.selection.TypeParagraph
    mo_appWD.selection.TypeText Text:=ls_TxtFooter

    'select the document
    'Call SelectSeekView(wdSeekCurrentPageFooter)
    'insert PAGE X OF Y
    'With mo_appWD
     '   NormalTemplate.AutoTextEntries("Page X of Y").Insert Where:=Selection. _
     '       Range
    'End With
    'Call SelectSeekView(wdSeekMainDocument)
    
 End If
 
Set lo_TableQuotLine = Nothing
ExportQuotationMetalToWord = OK

End Function



